class DSM_DMHUD extends ChallengeHUD;

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

#exec TEXTURE IMPORT NAME=Blackness FILE=Textures\Blackness.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Whiteness FILE=Textures\Whiteness.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Health FILE=Textures\Icon_Health.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Armor FILE=Textures\Icon_Armor.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Shield FILE=Textures\Icon_Shield.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Ammo FILE=Textures\Icon_Ammo.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Boots FILE=Textures\Icon_Boots.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Frags FILE=Textures\Icon_Frags.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Deaths FILE=Textures\Icon_Deaths.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Eff FILE=Textures\Icon_Eff.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=F2logo FILE=Textures\F2Logo.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_cpu FILE=Textures\Icon_cpu.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Con1 FILE=Textures\Icon_Con1.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Con2 FILE=Textures\Icon_Con2.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Con3 FILE=Textures\Icon_Con3.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Con4 FILE=Textures\Icon_Con4.bmp Group=HUD MIPS=ON

#exec TEXTURE IMPORT NAME=a001 FILE=Textures\a001.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a002 FILE=Textures\a002.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a003 FILE=Textures\a003.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a004 FILE=Textures\a004.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a005 FILE=Textures\a005.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a006 FILE=Textures\a006.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a007 FILE=Textures\a007.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a008 FILE=Textures\a008.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a009 FILE=Textures\a009.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a010 FILE=Textures\a010.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a011 FILE=Textures\a011.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a012 FILE=Textures\a012.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a013 FILE=Textures\a013.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a014 FILE=Textures\a014.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a015 FILE=Textures\a015.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a016 FILE=Textures\a016.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a017 FILE=Textures\a017.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a018 FILE=Textures\a018.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a019 FILE=Textures\a019.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a020 FILE=Textures\a020.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a021 FILE=Textures\a021.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a022 FILE=Textures\a022.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a023 FILE=Textures\a023.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a024 FILE=Textures\a024.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a025 FILE=Textures\a025.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a026 FILE=Textures\a026.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a027 FILE=Textures\a027.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a028 FILE=Textures\a028.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a029 FILE=Textures\a029.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a030 FILE=Textures\a030.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a031 FILE=Textures\a031.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a032 FILE=Textures\a032.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a033 FILE=Textures\a033.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a034 FILE=Textures\a034.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a035 FILE=Textures\a035.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a036 FILE=Textures\a036.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a037 FILE=Textures\a037.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a038 FILE=Textures\a038.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a039 FILE=Textures\a039.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a040 FILE=Textures\a040.bmp Group=Logo MIPS=ON
#exec TEXTURE IMPORT NAME=a041 FILE=Textures\a041.bmp Group=Logo MIPS=ON

#exec AUDIO IMPORT FILE=Sounds\UnrealTeamIntro.WAV NAME="IntroSound"

var bool bTimeDown, bFadeDown, bShowLogo, bIntroSound;
var Color BlackColor, SpawnColor, LogoColor;
var int LogoCounter, LogoFrame, C, ShowTime;

var float Speed, a, b, l, d, e, f, g, h, j, k;
var bool bSetStart;

//Team Beacon vars:
var float			mMinScale;
var float			mMaxScale;

simulated function DrawSpectators(Canvas Canvas)
{
local float XL, YL;
local Info_PRI IPRI;

	if ( Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec1 != "" )
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 );
		Canvas.DrawText("Spectators:", True);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 + YL );
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec1, True);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 + YL * 2 );
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec2, True);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 + YL * 3 );
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec3, True);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 + YL * 4 );
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec4, True);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 + YL * 5 );
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec5, True);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 + YL * 6 );
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec6, True);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 + YL * 7 );
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec7, True);
		Canvas.SetPos( 0 , Canvas.ClipY * 0.5 - 96 + YL * 8 );
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Spec8, True);
		}
}

simulated function DrawF2background(Canvas Canvas)
{
local float XL, YL, DrawScale;

	Canvas.DrawColor = BlueColor;
	Canvas.Style = ERenderStyle.STY_Translucent;

	XL = Canvas.ClipX * 0.5;
	YL = Canvas.ClipY * 0.5;
	if ( Canvas.ClipX < 1024 )
		{
		DrawScale = Canvas.ClipX / 1024;
		}
	else
		{
		DrawScale = 1;
		}
	Canvas.SetPos( XL - (DrawScale * 512) , YL - ( DrawScale * 256 ) );

	Canvas.DrawTile(Texture'F2logo', DrawScale * 1024, DrawScale * 512, 0, 0,1024,512);	
}

function DrawUT( canvas Canvas )
{
local float XL, YL, X, Y;

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !bSetStart )
		{
		//Speed = 0.00625;
		Speed = 0.005;
		a = 3;
		b = 3.05;
		l = 3.1;
		d = 3.15;
		e = 3.2;
		f = 3.25;
		g = 3.35;
		h = 3.4;
		j = 3.45;
		k = 3.5;
		bSetStart = True;
		}

	XL = Canvas.ClipX * 0.5;
	YL = Canvas.ClipY * 0.5 - 10;
	
	//Draw U
	X = Cos(a);
	Y = Sin(a);
	Canvas.SetPos(XL + YL * X  , YL + YL * Y );
	Canvas.DrawText("U", True);

	a -= Speed;
	if ( a < 0 )
		{
		a = 6.283185307;
		}
	//Draw n
	X = Cos(b);
	Y = Sin(b);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("n", True);

	b -= Speed;
	if ( b < 0 )
		{
		b = 6.283185307;
		}
	//Draw r
	X = Cos(l);
	Y = Sin(l);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("r", True);

	l -= Speed;
	if ( l < 0 )
		{
		l = 6.283185307;
		}
	//Draw e
	X = Cos(d);
	Y = Sin(d);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("e", True);

	d -= Speed;
	if ( d < 0 )
		{
		d = 6.283185307;
		}
	//Draw a
	X = Cos(e);
	Y = Sin(e);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("a", True);

	e -= Speed;
	if ( e < 0 )
		{
		e = 6.283185307;
		}
	//Draw l
	X = Cos(f);
	Y = Sin(f);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("l", True);

	f -= Speed;
	if ( f < 0 )
		{
		f = 6.283185307;
		}
	//Draw T
	X = Cos(g);
	Y = Sin(g);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("T", True);

	g -= Speed;
	if ( g < 0 )
		{
		g = 6.283185307;
		}
	//Draw e
	X = Cos(h);
	Y = Sin(h);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("e", True);

	h -= Speed;
	if ( h < 0 )
		{
		h = 6.283185307;
		}
	//Draw a
	X = Cos(j);
	Y = Sin(j);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("a", True);

	j -= Speed;
	if ( j < 0 )
		{
		j = 6.283185307;
		}
	//Draw m
	X = Cos(k);
	Y = Sin(k);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("m", True);

	k -= Speed;
	if ( k < 0 )
		{
		k = 6.283185307;
		}	
}

simulated function ServerStats(Canvas Canvas)
{
local GameReplicationInfo GRI;
local Info_PRI PRI;
local float XL, YL, YL2, YY, Eff, F, D;

	GRI = PlayerPawn(Owner).GameReplicationInfo;
	PRI = Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL2);
	Canvas.SetPos(0, 64);
	Canvas.DrawText(GRI.ServerName, True);
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0,64 + YL2);
	Canvas.DrawText("Admin:"@GRI.AdminName$", Contact via:"@GRI.AdminEmail, True);

	Canvas.DrawColor = GoldColor;

	YY = Canvas.ClipY * 0.5 - YL * 6;

	Canvas.SetPos(0, YY );
	Canvas.DrawText("Top 10 players on the server:", True);
	Canvas.SetPos(0, YY + YL * 2);

	F = PRI.Frags1;
	D = PRI.Deaths1;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("1st"@PRI.Name1$" with"@PRI.Frags1$" frags,"@PRI.Deaths1$" deaths,"@PRI.HS1$" headshots and"@PRI.G1$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 3);
	F = PRI.Frags2;
	D = PRI.Deaths2;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("2nd"@PRI.Name2$" with"@PRI.Frags2$" frags,"@PRI.Deaths2$" deaths,"@PRI.HS2$" headshots and"@PRI.G2$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 4);
	F = PRI.Frags3;
	D = PRI.Deaths3;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("3rd"@PRI.Name3$" with"@PRI.Frags3$" frags,"@PRI.Deaths3$" deaths,"@PRI.HS3$" headshots and"@PRI.G3$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 5);
	F = PRI.Frags4;
	D = PRI.Deaths4;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("4th"@PRI.Name4$" with"@PRI.Frags4$" frags,"@PRI.Deaths4$" deaths,"@PRI.HS4$" headshots and"@PRI.G4$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 6);
	F = PRI.Frags5;
	D = PRI.Deaths5;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("5th"@PRI.Name5$" with"@PRI.Frags5$" frags,"@PRI.Deaths5$" deaths,"@PRI.HS5$" headshots and"@PRI.G5$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 7);
	F = PRI.Frags6;
	D = PRI.Deaths6;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("6th"@PRI.Name6$" with"@PRI.Frags6$" frags,"@PRI.Deaths6$" deaths,"@PRI.HS6$" headshots and"@PRI.G6$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 8);
	F = PRI.Frags7;
	D = PRI.Deaths7;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("7th"@PRI.Name7$" with"@PRI.Frags7$" frags,"@PRI.Deaths7$" deaths,"@PRI.HS7$" headshots and"@PRI.G7$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 9);
	F = PRI.Frags8;
	D = PRI.Deaths8;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("8th"@PRI.Name8$" with"@PRI.Frags8$" frags,"@PRI.Deaths8$" deaths,"@PRI.HS8$" headshots and"@PRI.G8$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 10);
	F = PRI.Frags9;
	D = PRI.Deaths9;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("9th"@PRI.Name4$" with"@PRI.Frags9$" frags,"@PRI.Deaths9$" deaths,"@PRI.HS9$" headshots and"@PRI.G9$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.SetPos(0, YY + YL * 11);
	F = PRI.Frags10;
	D = PRI.Deaths10;
	Eff = F / (F + D);
	Eff *= 100;
	Canvas.DrawText("10th"@PRI.Name10$" with"@PRI.Frags10$" frags,"@PRI.Deaths10$" deaths,"@PRI.HS10$" headshots and"@PRI.G10$" games. Efficiency:"@int(Eff)$"%", True);
	Canvas.bCenter = False;

	DrawUT(canvas);
	DrawF2background(Canvas);
}

simulated function IntroLogo(Canvas Canvas)
{

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = C;
	Canvas.DrawColor.G = C;
	Canvas.DrawColor.B = C;
	
	Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 128);

	if ( LogoFrame == 1 )
		{
		Canvas.DrawTile(Texture'a001', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 2 )
		{
		Canvas.DrawTile(Texture'a002', 256, 256, 0, 0, 256, 256);
		if ( !bIntroSound )
			{
			PlayerPawn(Owner).PlaySound (Sound'IntroSound',,2.0);
			bIntroSound = True;
			}
		}
	else if ( LogoFrame == 3 )
		{
		Canvas.DrawTile(Texture'a003', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 4 )
		{
		Canvas.DrawTile(Texture'a004', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 5 )
		{
		Canvas.DrawTile(Texture'a005', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 6 )
		{
		Canvas.DrawTile(Texture'a006', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 7 )
		{
		Canvas.DrawTile(Texture'a007', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 8 )
		{
		Canvas.DrawTile(Texture'a008', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 9 )
		{
		Canvas.DrawTile(Texture'a009', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 10 )
		{
		Canvas.DrawTile(Texture'a010', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 11 )
		{
		Canvas.DrawTile(Texture'a011', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 12 )
		{
		Canvas.DrawTile(Texture'a012', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 13 )
		{
		Canvas.DrawTile(Texture'a013', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 14 )
		{
		Canvas.DrawTile(Texture'a014', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 15 )
		{
		Canvas.DrawTile(Texture'a015', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 16 )
		{
		Canvas.DrawTile(Texture'a016', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 17 )
		{
		Canvas.DrawTile(Texture'a017', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 18 )
		{
		Canvas.DrawTile(Texture'a018', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 19 )
		{
		Canvas.DrawTile(Texture'a019', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 20 )
		{
		Canvas.DrawTile(Texture'a020', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 21 )
		{
		Canvas.DrawTile(Texture'a021', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 22 )
		{
		Canvas.DrawTile(Texture'a022', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 23 )
		{
		Canvas.DrawTile(Texture'a023', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 24 )
		{
		Canvas.DrawTile(Texture'a024', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 25 )
		{
		Canvas.DrawTile(Texture'a025', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 26 )
		{
		Canvas.DrawTile(Texture'a026', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 27 )
		{
		Canvas.DrawTile(Texture'a027', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 28 )
		{
		Canvas.DrawTile(Texture'a028', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 29 )
		{
		Canvas.DrawTile(Texture'a029', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 30 )
		{
		Canvas.DrawTile(Texture'a030', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 31 )
		{
		Canvas.DrawTile(Texture'a031', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 32 )
		{
		Canvas.DrawTile(Texture'a032', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 33 )
		{
		Canvas.DrawTile(Texture'a033', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 34 )
		{
		Canvas.DrawTile(Texture'a034', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 35 )
		{
		Canvas.DrawTile(Texture'a035', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 36 )
		{
		Canvas.DrawTile(Texture'a036', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 37 )
		{
		Canvas.DrawTile(Texture'a037', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 38 )
		{
		Canvas.DrawTile(Texture'a038', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 39 )
		{
		Canvas.DrawTile(Texture'a039', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 40 )
		{
		Canvas.DrawTile(Texture'a040', 256, 256, 0, 0, 256, 256);
		}
	else if ( LogoFrame == 41 )
		{
		Canvas.DrawTile(Texture'a041', 256, 256, 0, 0, 256, 256);
		}
	LogoCounter++;
	if ( LogoCounter > 8 )
		{
		LogoFrame++;
		if ( LogoFrame >= 42 )
			LogoFrame = 1;
		LogoCounter = 0;
		}
	if ( !bFadeDown )
		{
		C++;
		if ( C >= 255 )
			{
			C = 255;
			ShowTime++;
			if ( ShowTime > 250 )
				{
				bFadeDown = True;
				}
			}
		}
	else
		{
		C--;
		if ( C <= 0 )
			{
			bShowLogo = False;
			}
		}
}

simulated function DrawAmmo(Canvas Canvas)
{
local float XL,YL;
local float DrawScale, i;

	if ( (PawnOwner.Weapon == None) || (PawnOwner.Weapon.AmmoType == None) || PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'Icon_Ammo', 32, 32, 0, 0, 32, 32);
	i = 128 / PawnOwner.Weapon.AmmoType.MaxAmmo;
	DrawScale = PawnOwner.Weapon.AmmoType.AmmoAmount * i;
	if ( DrawScale > 128 )
		DrawScale = 128;
	if ( DrawScale < 15 )
		Canvas.DrawColor = RedColor;
	else if ( DrawScale < 35 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.SetPos(Canvas.ClipX - 161 , Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Whiteness', DrawScale, 20, 0, 0, 1, 1);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 162, Canvas.ClipY - 27);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(Canvas.ClipX - 162, Canvas.ClipY - 6);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(Canvas.ClipX - 162, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.SetPos(Canvas.ClipX - 34, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.StrLen(PawnOwner.Weapon.AmmoType.AmmoAmount, XL, YL);
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos((Canvas.ClipX - 81) - 0.5 * XL, Canvas.ClipY - 24);
	Canvas.DrawText(PawnOwner.Weapon.AmmoType.AmmoAmount);

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen(PawnOwner.Weapon.ItemName, XL, YL);
	Canvas.SetPos(Canvas.ClipX - XL, Canvas.ClipY - (32 + YL) );
	Canvas.DrawText(PawnOwner.Weapon.ItemName);
	
}

//Customized to draw: Health + Armor + Frags + Boots + SpawnProtection
simulated function DrawBasicStats(Canvas Canvas)
{
local float XL,YL, DrawScale, i;
local inventory Inv;
local bool bSP;
local int Armor, Belt, Boots, spawn;
local TournamentGameReplicationInfo TGRI;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	Canvas.bCenter = True;
	Canvas.SetPos(0, 0);
	Canvas.DrawText("F2 = Serverstatistics");
	Canvas.bCenter = False;

	//Draw Health status
	Canvas.SetPos(0, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'Icon_Health', 32, 32, 0, 0, 32, 32);
	i = 128 / 199;
	DrawScale = PawnOwner.Health * i;
	if ( DrawScale < 15 )
		Canvas.DrawColor = RedColor;
	else if ( DrawScale < 35 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	if ( DrawScale > 128 )
		DrawScale = 128;
	Canvas.SetPos(35, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Whiteness', DrawScale, 20, 0, 0, 1, 1);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(34, Canvas.ClipY - 27);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 6);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.SetPos(162, Canvas.ClipY - 26);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.StrLen(PawnOwner.Health, XL, YL);
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(100 - 0.5 * XL, Canvas.ClipY - 24);
	Canvas.DrawText(PawnOwner.Health);

	//Draw Armor status
	Canvas.SetPos(0, Canvas.ClipY - 64);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	bSP = False;
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if (Inv.bIsAnArmor) 
			{
			if ( Inv.IsA('UT_Shieldbelt') )
				{
				Belt += Inv.Charge;
				}
			else
				{
				Armor += Inv.Charge;
				}
			}
		else if (Inv.IsA('UT_JumpBoots')) 
			{
			Boots = Inv.Charge;
			}
		else if (Inv.IsA('SpawnProtector')) 
			{
			Spawn = Inv.Charge;
			bSP = True;
			}
		}
	if ( Belt > Armor )
		{
		Canvas.DrawTile(Texture'Icon_Shield', 32, 32, 0, 0, 32, 32);
		i = Belt;
		}
	else
		{
		Canvas.DrawTile(Texture'Icon_Armor', 32, 32, 0, 0, 32, 32);
		i = Armor;
		}
	DrawScale = 128 / 150 * i;
	if ( DrawScale < 15 )
		Canvas.DrawColor = RedColor;
	else if ( DrawScale < 35 )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = GreenColor;
	if ( DrawScale > 128 )
		DrawScale = 128;
	Canvas.SetPos(35, Canvas.ClipY - 58);
	Canvas.DrawTile(Texture'Whiteness', DrawScale, 20, 0, 0, 1, 1);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(34, Canvas.ClipY - 59);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 38);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 58);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.SetPos(162, Canvas.ClipY - 58);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.StrLen(int(i), XL, YL);
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(100 - 0.5 * XL, Canvas.ClipY - 56);
	Canvas.DrawText(int(i));

	//Draw Frags
	Canvas.SetPos(0, Canvas.ClipY - 96);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawTile(Texture'Icon_Frags', 32, 32, 0, 0, 32, 32);
	i = 128 / TGRI.FragLimit;
	DrawScale = PawnOwner.PlayerReplicationInfo.Score * i;
	if ( DrawScale > 128 )
		DrawScale = 128;
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(35, Canvas.ClipY - 90);
	Canvas.DrawTile(Texture'Whiteness', DrawScale, 20, 0, 0, 1, 1);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(34, Canvas.ClipY - 91);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 71);
	Canvas.DrawTile(Texture'Blackness', 129, 1, 0, 0, 1, 1);
	Canvas.SetPos(34, Canvas.ClipY - 90);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.SetPos(162, Canvas.ClipY - 90);
	Canvas.DrawTile(Texture'Blackness', 1, 20, 0, 0, 1, 1);
	Canvas.StrLen(int(PawnOwner.PlayerReplicationInfo.Score)$"/"$TGRI.FragLimit, XL, YL);
	Canvas.DrawColor = BlackColor;
	Canvas.SetPos(100 - 0.5 * XL, Canvas.ClipY - 88);
	Canvas.DrawText(int(PawnOwner.PlayerReplicationInfo.Score)$"/"$TGRI.FragLimit);

	//Draw Boots
	if ( Boots > 0 )
		{
		Canvas.SetPos(0, Canvas.ClipY - 128);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = WhiteColor;
		Canvas.DrawTile(Texture'Icon_Boots', 32, 32, 0, 0, 32, 32);
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(34, Canvas.ClipY - 120);
		Canvas.DrawText(Boots);
		}

	//Draw SpawnProtection Info:
	if ( Spawn > 0 || bSP )
		{
		if ( SpawnColor.R <= 0 )
			{
			SpawnColor.R = 255;
			SpawnColor.G = 255;
			SpawnColor.B = 255;
			}

		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = SpawnColor;
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		Canvas.StrLen("Spawnprotection active:"@Spawn, XL, YL);
		Canvas.bCenter = True;
		Canvas.SetPos(0, Canvas.ClipY - 128);
		Canvas.DrawText("Spawnprotection active:"@Spawn + 1);
		Canvas.bCenter = False;

		SpawnColor.R -= 3;
		SpawnColor.G -= 3;
		SpawnColor.B -= 3;

		}
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
	local float XL, YL, XOffset, YOffset;
	local int MaxPlayers;
	local string Spread;

	if ( (PawnOwner.PlayerReplicationInfo == None) 
		|| PawnOwner.PlayerReplicationInfo.bIsSpectator 
		|| (PlayerCount == 1) )
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;

	Canvas.bCenter = True;

	// Rank String
	Canvas.StrLen(RankString, XL, YL);

	YOffset = Canvas.ClipY - 2 * YL;

	Canvas.SetPos(0, YOffset);
	if (bTiedScore)
		Canvas.DrawColor = RedColor;
	Canvas.DrawText(RankString$" "$Rank@"/"@PlayerCount, False);
	Canvas.DrawColor = WhiteColor;

	// Spread String
	Canvas.SetPos(0, YOffset + YL);
	if (Lead > 0)
		Spread = SpreadString$" +"$Lead;
	else
		Spread = SpreadString$" "$Lead;

	Canvas.DrawText(Spread, False);

	Canvas.bCenter = False;
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTimeInfo( canvas Canvas )
{
local int Hours, Minutes, Seconds;
local float XL, YL;
local PlayerPawn PlayerOwner;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);

	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
		{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			{
			Canvas.StrLen("00:00", XL, YL);
			Canvas.SetPos(Canvas.ClipX - XL, 0);	
			Canvas.DrawText("00:00", true);
			}
		else
			{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.StrLen(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
			Canvas.SetPos(Canvas.ClipX - XL, 0);
			Canvas.DrawText(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
			}
		}
	else
		{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.StrLen(TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
		Canvas.SetPos(Canvas.ClipX - XL, 0);
		Canvas.DrawText(TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
}

simulated function PostRender( canvas Canvas )
{
	local float XL, YL, XPos, YPos, FadeValue;
	local string Message;
	local int M, i, j, k, XOverflow;
	local float OldOriginX;

	if ( bShowLogo )
		IntroLogo(Canvas);

	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( bShowInfo )
	{
		ServerStats( Canvas );
		return;
	}
	if ( !PlayerOwner.bShowScores && !bForceScores )
		{
		DrawBasicStats(Canvas);	//Cusomized version
		DrawSpectators(Canvas);
		}
	DrawTimeInfo(canvas);

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		//DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);


		 
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;

			// Draw Ammo
			if ( !bHideAmmo )
				DrawAmmo(Canvas);
			

		}


		// Team Game Synopsis
		if ( !bHideTeamInfo )
			DrawGameSynopsis(Canvas);

		// Display Identification Info
		if ( PawnOwner == PlayerOwner )
			{
			TracePlayers(Canvas);
			}

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
}

function DrawTeamBeacon(Canvas Canvas)
{
	local Pawn 		P;
	local float 	dist;
	local Vector	dir;
	local Vector	loc;
	local byte 		team_id;
	local int		num_used;
	local int 		player_id;
	local int		team_count;
	local int		symbol_count;
	local float		draw_scale;
	local float		interp;
	
	local PlayerReplicationInfo PRI;
	local TeamBeacon s;

	local float X,Y,Z;

	if (PawnOwner == None)// || !PlayerOwner.Level.Game.bTeamGame)
	{
		return;
	}

	// get the player's information
	team_id = PlayerOwner.PlayerReplicationInfo.Team;
	player_id = PlayerOwner.PlayerReplicationInfo.PlayerID;
	
	num_used = 0;
	team_count = 0;
	symbol_count = 0;
	// count the symbols in the client environment and set them available
	foreach AllActors (class 'TeamBeacon', s)
	{
		symbol_count++;
		s.bHidden = True; // we use this to set the symbol as 'available' for assignment
	}
	foreach AllActors (class'Pawn', P)
	{
		PRI = P.PlayerReplicationInfo;
		if ( PRI == None )
			continue;
		if ( team_id == PRI.Team && player_id != PRI.PlayerID)
		{
			team_count++;
			if (team_count > symbol_count)// spawn if need more
			{
				s = Spawn(class 'TeamBeacon', P);
				s.bHidden = P.bHidden;
				s.SetOwner(P);
				symbol_count++;
			}
			else // otherwise, assign a free IdentitySymbol to someone
			{
				foreach AllActors (class 'TeamBeacon', s)
				{
					if (s.bHidden == True)
					{
						s.bHidden = P.bHidden;
						s.SetOwner(P);
						break;
					}
				}
			}

			// set sprite location above their head
			loc = P.Location;
			loc.z += P.CollisionHeight * 1.75;
			// interp from min/max view distance, to scale the sprite based on distance
			dir = P.Location - PlayerOwner.Location;
			dist = VSize(Dir);
			interp = Dist/32768.0;
		
			// adjust sprite scale if zooming :kludged values:
			interp -= 0.3 * (1.0-(PlayerOwner.FOVAngle / PlayerOwner.DesiredFOV));
			// clamp
			if (interp < 0.0)
				interp = 0.0;
			if (interp > 1.0)
				interp = 1.0;
			draw_scale = Lerp( interp, mMinScale, mMaxScale); 
			s.SetLocation(loc);
			s.DrawScale = draw_scale;
			s.Texture = texture'TeamBeacon';

		}
	}
}

simulated function TracePlayers(Canvas C)
{
local string HUDname;	
local float Dist, XL, YL;
local Pawn P;
local int XPos, YPos;
local Vector X,Y,Z, Dir;

	GetAxes(Owner.Rotation, X, Y, Z);
	C.Font = MyFonts.GetSmallFont( C.ClipX );
	C.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'Pawn', P, 500, Owner.Location, true)
		{
		if ( P.PlayerReplicationInfo.Team == 0 )
			C.DrawColor = RedColor;
		else if ( P.PlayerReplicationInfo.Team == 1 )
			C.DrawColor = BlueColor;
		else if ( P.PlayerReplicationInfo.Team == 2 )
			C.DrawColor = GreenColor;
		else
			C.DrawColor = GoldColor;
		Dir = P.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(P.PlayerReplicationInfo.PlayerName$"("$P.Health$")", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < 0)
				{
				XPos = 0;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos + 48 );
			C.DrawText(P.PlayerReplicationInfo.PlayerName$"("$P.Health$")", true);
			}
		}
}

defaultproperties
{
BlackColor=(R=255,G=255,B=0)
LogoFrame=1
LogoColor=(R=0,G=0,B=0)
bShowLogo=True
mMinScale=0.300000
mMaxScale=14.000000
}
